#!/bin/bash

# SAAM Cabins - CMS Activation Script
echo "🚀 SAAM Cabins CMS Activation Script"
echo "==================================="
echo ""

# Check if CMS files exist
if [ ! -f "src/app/page-cms.tsx" ]; then
    echo "❌ Error: CMS files not found!"
    echo "Please ensure you have the CMS-enabled files in your project."
    exit 1
fi

# Check if .env.local exists
if [ ! -f ".env.local" ]; then
    echo "⚠️  Warning: .env.local file not found"
    echo "Creating .env.local from example..."
    cp .env.local.example .env.local
    echo "✅ Created .env.local file"
    echo "👉 Please edit .env.local and add your Contentful credentials"
    echo ""
fi

# Backup current homepage
echo "📦 Backing up current homepage..."
if [ -f "src/app/page.tsx" ]; then
    mv src/app/page.tsx src/app/page-static.tsx
    echo "✅ Static homepage backed up to page-static.tsx"
fi

# Activate CMS homepage
echo "🔄 Activating CMS homepage..."
mv src/app/page-cms.tsx src/app/page.tsx
echo "✅ CMS homepage activated!"

echo ""
echo "🎉 CMS Integration Complete!"
echo ""
echo "Next steps:"
echo "1. Edit .env.local with your Contentful credentials"
echo "2. Set up content models in Contentful (see CONTENTFUL-SETUP.md)"
echo "3. Add your content in Contentful"
echo "4. Run 'npm run dev' to test your CMS-powered website"
echo ""
echo "📚 Full setup guide: CONTENTFUL-SETUP.md"
echo "📋 CMS guide: CMS-SETUP-GUIDE.md"
echo ""